<?php

/**
 * @file controllers/grid/catalogEntry/MarketsGridRow.inc.php
 *
 * Copyright (c) 2014-2021 Simon Fraser University
 * Copyright (c) 2000-2021 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class MarketsGridRow
 * @ingroup controllers_grid_catalogEntry
 *
 * @brief Markets grid row definition
 */

import('lib.pkp.classes.controllers.grid.GridRow');

class MarketsGridRow extends GridRow {
	/** @var Monograph **/
	var $_monograph;

	/** @var Publication **/
	var $_publication;

	/**
	 * Constructor
	 */
	function __construct($monograph, $publication) {
		$this->_monograph = $monograph;
		$this->_publication = $publication;
		parent::__construct();
	}

	//
	// Overridden methods from GridRow
	//
	/**
	 * @copydoc GridRow::initialize()
	 */
	function initialize($request, $template = null) {
		// Do the default initialization
		parent::initialize($request, $template);

		$monograph = $this->getMonograph();

		// Is this a new row or an existing row?
		$market = $this->_data;

		if ($market != null && is_numeric($market->getId())) {
			$router = $request->getRouter();
			$actionArgs = array(
				'submissionId' => $monograph->getId(),
				'publicationId' => $this->_publication->getId(),
				'marketId' => $market->getId()
			);

			// Add row-level actions
			import('lib.pkp.classes.linkAction.request.AjaxModal');
			$this->addAction(
				new LinkAction(
					'editMarket',
					new AjaxModal(
						$router->url($request, null, null, 'editMarket', null, $actionArgs),
						__('grid.action.edit'),
						'modal_edit'
					),
					__('grid.action.edit'),
					'edit'
				)
			);

			import('lib.pkp.classes.linkAction.request.RemoteActionConfirmationModal');
			$this->addAction(
				new LinkAction(
					'deleteMarket',
					new RemoteActionConfirmationModal(
						$request->getSession(),
						__('common.confirmDelete'),
						__('common.delete'),
						$router->url($request, null, null, 'deleteMarket', null, $actionArgs),
						'modal_delete'
					),
					__('grid.action.delete'),
					'delete'
				)
			);
		}
	}

	/**
	 * Get the monograph for this row (already authorized)
	 * @return Monograph
	 */
	function getMonograph() {
		return $this->_monograph;
	}
}

